-- new script file
function OnAfterSceneLoaded(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.farmers:LinkToTarget("questFarmers")
  end
end

function OnBeforeDeath(self)
  self.farmers:TriggerAllTargets()
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
  end
end

function CreateTriggerSources(self)
  self:AddTriggerSource("farmers")
end
